/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.colony.buildings.moduleviews.WarehouseOptionsModuleView;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.warehouse.SortWarehouseMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.warehouse.UpgradeWarehouseMessage;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WarehouseOptionsModuleWindow
extends AbstractModuleWindow {
    private static final int BUILDING_LEVEL_FOR_SORTING = 3;
    private final WarehouseOptionsModuleView module;
    private boolean lockUpgrade = false;

    public WarehouseOptionsModuleWindow(IBuildingView building, WarehouseOptionsModuleView module) {
        super(building, "minecolonies:gui/layouthuts/layoutwarehouseoptions.xml");
        this.registerButton("resourceAdd", this::transferItems);
        this.registerButton("sort", this::sortWarehouse);
        this.module = module;
    }

    public void onOpened() {
        if (this.buildingView.getBuildingLevel() < 3) {
            ButtonImage sortButton = (ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.warehouse.sort.disabled.1", new Object[]{3}))).appendNL((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.warehouse.sort.disabled.2", new Object[]{3}))).hoverPane((Pane)sortButton).build();
            sortButton.disable();
        }
        super.onOpened();
        this.updateResourcePane();
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.buildingView));
    }

    private void updateResourcePane() {
        BuildingBuilderResource resource = new BuildingBuilderResource(new ItemStack((IItemProvider)Blocks.field_150475_bE, 1), 1);
        PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
        boolean isCreative = this.mc.field_71439_g.func_184812_l_();
        int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), resource.getItem());
        resource.setPlayerAmount(amountToSet);
        Text resourceLabel = (Text)this.findPaneOfTypeByID("resourceName", Text.class);
        Text resourceMissingLabel = (Text)this.findPaneOfTypeByID("resourceMissing", Text.class);
        Text neededLabel = (Text)this.findPaneOfTypeByID("resourceAvailableNeeded", Text.class);
        Button addButton = (Button)this.findPaneOfTypeByID("resourceAdd", Button.class);
        BuildingBuilderResource.RessourceAvailability availability = resource.getAvailabilityStatus();
        if (this.module.getStorageUpgradeLevel() >= 3 || this.buildingView.getBuildingLevel() < this.buildingView.getBuildingMaxLevel() || this.lockUpgrade) {
            availability = BuildingBuilderResource.RessourceAvailability.NOT_NEEDED;
        }
        ((Text)this.findPaneOfTypeByID("upgradeProgress", Text.class)).setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.xofz", (Object[])new Object[]{this.module.getStorageUpgradeLevel(), 3}));
        switch (availability) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColors(WindowBuilderResModule.DARKGREEN);
                resourceMissingLabel.setColors(WindowBuilderResModule.DARKGREEN);
                neededLabel.setColors(WindowBuilderResModule.DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColors(WindowBuilderResModule.BLACK);
                resourceMissingLabel.setColors(WindowBuilderResModule.BLACK);
                neededLabel.setColors(WindowBuilderResModule.BLACK);
                if (this.buildingView.getBuildingLevel() >= this.buildingView.getBuildingMaxLevel()) break;
                resourceLabel.hide();
                resourceMissingLabel.hide();
                neededLabel.hide();
                addButton.setText(new StringTextComponent("X").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED)));
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.warehouse.upgrade.disabled.1", new Object[]{this.buildingView.getBuildingMaxLevel()}))).appendNL((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.warehouse.upgrade.disabled.2", new Object[]{this.buildingView.getBuildingMaxLevel()}))).hoverPane((Pane)addButton).build();
            }
        }
        resourceLabel.setText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setText(Integer.toString(missing));
        } else {
            resourceMissingLabel.clearText();
        }
        neededLabel.setText(resource.getAvailable() + " / " + resource.getAmount());
        ((Text)this.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        if (this.buildingView.getBuildingLevel() >= this.buildingView.getBuildingMaxLevel()) {
            ItemStack resourceStackOfOne = new ItemStack((IItemProvider)resource.getItem(), 1);
            resourceStackOfOne.func_77982_d(resource.getItemStack().func_77978_p());
            ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resourceStackOfOne);
        }
    }

    private void transferItems() {
        Network.getNetwork().sendToServer(new UpgradeWarehouseMessage(this.buildingView));
        this.module.incrementStorageUpgrade();
        this.lockUpgrade = true;
        this.updateResourcePane();
    }

    private void sortWarehouse() {
        if (this.buildingView.getBuildingLevel() >= 3) {
            Network.getNetwork().sendToServer(new SortWarehouseMessage(this.buildingView));
            LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"com.minecolonies.coremod.gui.warehouse.sorted", (Object[])new Object[0]);
        }
    }
}

